<?php

namespace App\Http\Controllers;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\JsonResponse;
use Brian2694\Toastr\Facades\Toastr;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Box\Spout\Common\Exception\InvalidArgumentException;
use Box\Spout\Common\Exception\IOException;
use Box\Spout\Common\Exception\UnsupportedTypeException;
use Box\Spout\Writer\Exception\WriterNotOpenedException;
use Illuminate\Http\Request;
use App\Model\HomeBanner;
use App\Model\Testimonial;
use App\Model\SocialMedia;
use App\Model\ContactUs;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        /*$this->middleware('auth');*/
    }
    /**
     * Show the application dashboard.
     *
     * @return Renderable
     */
    public function index(): Renderable
    {
        // return view('home');
        $banner= HomeBanner::where('status',1)->get();
        $testimonial= Testimonial::where('status',1)->get();
        return view('home-index', compact('banner','testimonial'));
    }
    /**
     * @return Factory|View|Application
     */
    public function about_us(): Factory|View|Application
    {
        return view('about-us');
    }
    /**
     * @return Factory|View|Application
     */
    public function terms_and_conditions(): Factory|View|Application
    {
        return view('terms-and-conditions');
    }
    /**
     * @return Factory|View|Application
     */
    public function privacy_policy(): Factory|View|Application
    {
        return view('privacy-policy');
    }

     public function shipping_policy(): Factory|View|Application
    {

        return view('shipping-policy');
    }

    public function contact_us(): Factory|View|Application
    {
        return view('contact-us');
    }
    public function contact_us_store(Request $request)
    {
        $request->validate([
            'fullname' => 'required|string|max:20',
            'email' => 'required|email',
            // 'state' => 'required|string',
            'number' => 'required|digits_between:1,11',
            'comment' => 'required|string|max:200',
        ]);
        ContactUs::insert([
            'fullname' => $request->fullname,
            'email' => $request->email,
            'state' => $request->state,
            'number' => $request->number,
            'contact_number' => $request->state.$request->number,
            'comment' => $request->comment,
        ]);
        Toastr::success(translate('Thank You.. for contacting us, We will get back to you soon!'));
        return redirect()->back();
    }
    public function refund_cancellation(): Factory|View|Application
    {
        return view('refund-cancellation');
    }
}