@extends('layouts.new_blank')
@push('css_or_js')
    <meta name="csrf-token" content="{{ csrf_token() }}">  
@endpush
@section('content')
    <section class="innerPages contactUs">
        <div class="innerBanner">
            <img
                src="{{asset('public/assets/installation')}}/assets/images/contact-us.png"
                alt="banner"
                class="img-fluid"
            />
        </div>
        <div class="container-fluid px-0 mt-5">
            <div class="row gy-4">
                <div class="col-md-7">
                    <div class="contactForm">
                        <form class="row gy-4" action="{{route('contact-us-store')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="col-md-12">
                                <label for="fullName" class="form-label"
                                >Full Name <span>*</span></label
                                >
                                <input type="text" name="fullname" class="form-control" id="fullName" value="{{ old('fullname') }}" required/>
                            </div>
                            <div class="col-md-6">
                                <label for="email" class="form-label"
                                >Email <span>*</span></label
                                >
                                <input type="text" name="email" class="form-control" id="email" value="{{ old('email') }}" required/>
                            </div>
                            <div class="col-md-6">
                                <label for="inputAddress" class="form-label">Phone Number <span>*</span></label>
                                <div class="d-flex align-items-center phoneNumber">
                                    <div class="countryCode position-relative">
                                        <select name="state" id="inputState" class="form-select" required>
                                            <option value='+91' {{ old('state') == '+91' ? 'selected' : '' }}>+91</option>
                                            <option value='+55' {{ old('state') == '+55' ? 'selected' : '' }}>+55</option>
                                        </select>
                                    </div>
                                    <input
                                        type="text"
                                        class="form-control"
                                        id="address" name="number" value="{{ old('number') }}" required
                                    />
                                </div>
                            </div>
                            <div class="col-md-12">
                                    <div class="form-floating">
                                    <textarea
                                        class="form-control" name="comment" required
                                        placeholder="Leave a comment here"
                                        id="floatingTextarea2"
                                        style="height: 130px"
                                    >{{ old('comment') }}</textarea>
                                    <label for="floatingTextarea2" class="form-label">Comments<span>*</span></label>
                                </div>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">Send Message</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="bannerImg">
                        <img src="{{asset('public/assets/installation')}}/assets/images/contactbanner.png" alt="banner" class="img-fluid">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="cta py-5 contactCta">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-md-6">
                    <div class="bannerImg">
                        <img src="{{asset('public/assets/installation')}}/assets/images/cta.png" alt="banner" class="img-fluid" />
                    </div>
                </div>
                <div class="col-md-5 align-self-center">
                    <div class="sectionHead d-flex flex-column gap-2">
                        <h2>
                            Download the <br />
                            App Now !
                        </h2>
                        <p>From Manu’s Kitchen to Your Table—With Love</p>
                        <div class="downloadBtn">
                            <a href="#">
                                <img
                                src="{{asset('public/assets/installation')}}/assets/images/andriod.png"
                                alt="btn"
                                class="img-fluid"
                                />
                            </a>
                            <a href="#">
                                <img
                                src="{{asset('public/assets/installation')}}/assets/images/appstore.png"
                                alt="btn"
                                class="img-fluid"
                                />
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
{{-- @section('content')
    <div class="innerBanner">
        <img
        src="{{asset('public/assets/installation')}}/assets/images/contact-us.png"
        alt="banner"
        class="img-fluid"
        />
    </div>
    <div class="container-fluid px-0 mt-5">
        <div class="row gy-4">
            <div class="col-md-7">
                <div class="contactForm">
                    <form class="row gy-4">
                        <div class="col-md-12">
                            <label for="fullName" class="form-label"
                                >Full Name <span>*</span></label
                            >
                            <input type="text" class="form-control" id="fullName" />
                        </div>
                        <div class="col-md-6">
                            <label for="email" class="form-label"
                                >Email <span>*</span></label
                            >
                            <input type="text" class="form-control" id="email" />
                        </div>
                        <div class="col-md-6">
                            <label for="inputAddress" class="form-label">Phone Number <span>*</span></label>
                            <div class="d-flex align-items-center phoneNumber">
                                <div class="countryCode position-relative">
                                    <select id="inputState" class="form-select">
                                        <option selected>+91</option>
                                        <option>+55</option>
                                    </select>
                                </div>
                                <input
                                type="text"
                                class="form-control"
                                id="inputAddress"
                                />
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-floating">
                                <textarea
                                class="form-control"
                                placeholder="Leave a comment here"
                                id="floatingTextarea2"
                                style="height: 130px"
                                ></textarea>
                                <label for="floatingTextarea2" class="form-label">Comments</label>
                            </div>
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary">Send Message</button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-md-5">
                <div class="bannerImg">
                    <img src="{{asset('public/assets/installation')}}/assets/images/contactbanner.png" alt="banner" class="img-fluid">
                </div>
            </div>
        </div>
    </div>
@endsection
<section class="cta py-5 contactCta">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-md-6">
                <div class="bannerImg">
                    <img src="{{asset('public/assets/installation')}}/assets/images/cta.png" alt="banner" class="img-fluid" />
                </div>
            </div>
            <div class="col-md-5 align-self-center">
                <div class="sectionHead d-flex flex-column gap-2">
                    <h2>
                    Download the <br />
                    App Now !
                    </h2>
                    <p>
                        Lorem Ipsum is simply dummy text of the printing and typesetting
                        industry. Lorem Ipsu has been the industry's standard dummy text
                        ever since the 1500s.
                    </p>
                    <div class="downloadBtn">
                        <a href="#">
                            <img
                            src="{{asset('public/assets/installation')}}/assets/images/andriod.png"
                            alt="btn"
                            class="img-fluid"
                            />
                        </a>
                        <a href="#">
                            <img
                            src="{{asset('public/assets/installation')}}/assets/images/appstore.png"
                            alt="btn"
                            class="img-fluid"
                            />
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section> --}}
@push('script')
    <script>
        $(document).ready(function () {
            document.getElementsByClassName("ql-editor")[0].contentEditable = "false";
        });
    </script>
@endpush