@extends('layouts.new_blank')

@push('css_or_js')
    <style>
        input{
            display: none!important;
        }
    </style>
@endpush
@section('content')
    <section class="heroSection">
        <div class="swiper mySwiper">
            <div class="swiper-wrapper">
                @foreach($banner as $banner_image) 
                    <div class="swiper-slide">
                        <img
                            src="{{ asset('storage/app/public/' . $banner_image->image) }}"
                            alt="banner"
                            class="img-fluid"
                        />
                    </div>
                @endforeach
            </div>
            <div class="swiper-pagination mt-4"></div>
        </div>
    </section>
    <!-- Hero section -->
    <!-- How Does eFood Work? -->
    <section class="efoodWork py-5">
        <div class="container">
            <div class="sectionHead w-75 mx-auto text-center">
                <h2>How Does Manu’s kitchen <span>Work?</span></h2>
                <p>
                    Hungry? We’re already on the way.
                </p>
            </div>
            <div class="bannerImg text-center">
                <img
                src="{{asset('public/assets/installation')}}/assets/images/deliveryWorks.png"
                alt="banner"
                class="img-fluid"
                />
            </div>
        </div>
    </section>
    <!-- How Does eFood Work? -->
    <!-- Download the App Now ! -->
    <section class="cta py-5">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-md-6">
                    <div class="bannerImg">
                        <img src="{{asset('public/assets/installation')}}/assets/images/cta.png" alt="banner" class="img-fluid">
                    </div>
                </div>
                <div class="col-md-5 align-self-center">
                    <div class="sectionHead d-flex flex-column gap-2">
                        <h2>Download the <br> App Now !</h2>
                        <p>From Manu’s Kitchen to Your Table—With Love</p>
                        <div class="downloadBtn">
                            <a href="https://play.google.com/store/apps/details?id=com.sixamtech.efoodapp&hl=en_IN">
                                <img src="{{asset('public/assets/installation')}}/assets/images/andriod.png" alt="btn" class="img-fluid">
                            </a>
                            <a href="https://apps.apple.com/in/app/manus-kitchen/id6749685242">
                                <img src="{{asset('public/assets/installation')}}/assets/images/appstore.png" alt="btn" class="img-fluid">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Download the App Now ! -->
    <!-- Customer Reviews -->
    <section class="customerReviews py-5">
        <div class="container">
            <div class="sectionHead mb-4">
                <h3>Customer Reviews</h3>
            </div>
            <div class="swiper customerSlider">
                <div class="swiper-wrapper">
                    @foreach($testimonial as $testimonials)
                        <div class="swiper-slide">
                            <div class="testimonial-card">
                                <div class="stars">
                                    @for ($i = 1; $i <= 5; $i++)
                                        @if ($i <= $testimonials->star_rating)
                                            <i class="fas fa-star"></i> {{-- filled star --}}
                                        @else
                                            <i class="far fa-star text-muted"></i> {{-- empty star --}}
                                        @endif
                                    @endfor
                                </div>
                                <p class="testimonial-text">
                                    {{$testimonials->description}}
                                </p>
                                <div class="user-info">
                                    <img
                                    src="{{ asset('storage/app/public/' . $testimonials->customer_image) }}"
                                    alt="User photo"
                                    class="user-photo"
                                    />
                                    <div>
                                    <div class="user-name">{{$testimonials->customer_name}}</div>
                                    <div class="user-role">{{$testimonials->customer_designation}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="btnBlock mt-3">
                    <div class="swiper-pagination"></div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('script')
    <script>
        $(document).ready(function () {
            document.getElementsByClassName("ql-editor")[0].contentEditable = "false";
        });
    </script>
@endpush